/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.dns.DefaultDnsOptEcsRecord;
import io.netty.handler.codec.dns.DefaultDnsRecordEncoder;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Test;

public class DefaultDnsRecordEncoderTest {
    @Test
    public void testEncodeName() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0}, "netty.io.");
    }

    @Test
    public void testEncodeNameWithoutTerminator() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0}, "netty.io");
    }

    @Test
    public void testEncodeNameWithExtraTerminator() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{5, 110, 101, 116, 116, 121, 2, 105, 111, 0}, "netty.io..");
    }

    @Test
    public void testEncodeEmptyName() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{0}, "");
    }

    @Test
    public void testEncodeRootName() throws Exception {
        DefaultDnsRecordEncoderTest.testEncodeName(new byte[]{0}, ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testEncodeName(byte[] expected, String name) throws Exception {
        DefaultDnsRecordEncoder encoder = new DefaultDnsRecordEncoder();
        ByteBuf out = Unpooled.buffer();
        ByteBuf expectedBuf = Unpooled.wrappedBuffer((byte[])expected);
        try {
            encoder.encodeName(name, out);
            Assert.assertEquals((Object)expectedBuf, (Object)out);
        }
        finally {
            out.release();
            expectedBuf.release();
        }
    }

    @Test
    public void testOptEcsRecordIpv4() throws Exception {
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"1.2.3.4"));
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"1.2.3.255"));
    }

    @Test
    public void testOptEcsRecordIpv6() throws Exception {
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"::0"));
        DefaultDnsRecordEncoderTest.testOptEcsRecordIp(SocketUtils.addressByName((String)"::FF"));
    }

    private static void testOptEcsRecordIp(InetAddress address) throws Exception {
        int addressBits = address.getAddress().length * 8;
        for (int i = 0; i <= addressBits; ++i) {
            DefaultDnsRecordEncoderTest.testIp(address, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testIp(InetAddress address, int prefix) throws Exception {
        int lowOrderBitsToPreserve = prefix % 8;
        ByteBuf addressPart = Unpooled.wrappedBuffer((byte[])address.getAddress(), (int)0, (int)DefaultDnsRecordEncoder.calculateEcsAddressLength((int)prefix, (int)lowOrderBitsToPreserve));
        if (lowOrderBitsToPreserve > 0) {
            int idx = addressPart.writerIndex() - 1;
            byte lastByte = addressPart.getByte(idx);
            int paddingMask = ~((1 << 8 - lowOrderBitsToPreserve) - 1);
            addressPart.setByte(idx, lastByte & paddingMask);
        }
        int payloadSize = DefaultDnsRecordEncoderTest.nextInt(Short.MAX_VALUE);
        int extendedRcode = DefaultDnsRecordEncoderTest.nextInt(254);
        int version = DefaultDnsRecordEncoderTest.nextInt(254);
        DefaultDnsRecordEncoder encoder = new DefaultDnsRecordEncoder();
        ByteBuf out = Unpooled.buffer();
        try {
            DefaultDnsOptEcsRecord record = new DefaultDnsOptEcsRecord(payloadSize, extendedRcode, version, prefix, address.getAddress());
            encoder.encodeRecord((DnsRecord)record, out);
            Assert.assertEquals((long)0L, (long)out.readByte());
            Assert.assertEquals((long)DnsRecordType.OPT.intValue(), (long)out.readUnsignedShort());
            Assert.assertEquals((long)payloadSize, (long)out.readUnsignedShort());
            Assert.assertEquals((long)record.timeToLive(), (long)out.getUnsignedInt(out.readerIndex()));
            Assert.assertEquals((long)extendedRcode, (long)out.readUnsignedByte());
            Assert.assertEquals((long)version, (long)out.readUnsignedByte());
            Assert.assertEquals((long)extendedRcode, (long)record.extendedRcode());
            Assert.assertEquals((long)version, (long)record.version());
            Assert.assertEquals((long)0L, (long)record.flags());
            Assert.assertEquals((long)0L, (long)out.readShort());
            int payloadLength = out.readUnsignedShort();
            Assert.assertEquals((long)payloadLength, (long)out.readableBytes());
            Assert.assertEquals((long)8L, (long)out.readShort());
            int rdataLength = out.readUnsignedShort();
            Assert.assertEquals((long)rdataLength, (long)out.readableBytes());
            Assert.assertEquals((long)((short)InternetProtocolFamily.of((InetAddress)address).addressNumber()), (long)out.readShort());
            Assert.assertEquals((long)prefix, (long)out.readUnsignedByte());
            Assert.assertEquals((long)0L, (long)out.readUnsignedByte());
            Assert.assertEquals((Object)addressPart, (Object)out);
        }
        finally {
            addressPart.release();
            out.release();
        }
    }

    private static int nextInt(int max) {
        return PlatformDependent.threadLocalRandom().nextInt(max);
    }
}

