/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DnsQueryTest {
    @Test
    public void writeQueryTest() throws Exception {
        InetSocketAddress addr = SocketUtils.socketAddress((String)"8.8.8.8", (int)53);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new DatagramDnsQueryEncoder()});
        ArrayList<DatagramDnsQuery> queries = new ArrayList<DatagramDnsQuery>(5);
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("1.0.0.127.in-addr.arpa", DnsRecordType.PTR)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("www.example.com", DnsRecordType.A)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("example.com", DnsRecordType.AAAA)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("example.com", DnsRecordType.MX)));
        queries.add(new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion("example.com", DnsRecordType.CNAME)));
        for (DnsQuery dnsQuery : queries) {
            Assert.assertThat((Object)dnsQuery.count(DnsSection.QUESTION), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)dnsQuery.count(DnsSection.ANSWER), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)dnsQuery.count(DnsSection.AUTHORITY), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)dnsQuery.count(DnsSection.ADDITIONAL), (Matcher)Matchers.is((Object)0));
            embedder.writeOutbound(new Object[]{dnsQuery});
            DatagramPacket packet = (DatagramPacket)embedder.readOutbound();
            Assert.assertTrue((boolean)((ByteBuf)packet.content()).isReadable());
            packet.release();
            Assert.assertNull((Object)embedder.readOutbound());
        }
    }
}

