/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.microbench.channel.EmbeddedChannelHandlerContext;
import io.netty.util.internal.ObjectUtil;

public abstract class EmbeddedChannelWriteAccumulatingHandlerContext
extends EmbeddedChannelHandlerContext {
    private ByteBuf cumulation;
    private ByteToMessageDecoder.Cumulator cumulator;

    protected EmbeddedChannelWriteAccumulatingHandlerContext(ByteBufAllocator alloc, ChannelHandler handler, ByteToMessageDecoder.Cumulator writeCumulator) {
        this(alloc, handler, writeCumulator, new EmbeddedChannel());
    }

    protected EmbeddedChannelWriteAccumulatingHandlerContext(ByteBufAllocator alloc, ChannelHandler handler, ByteToMessageDecoder.Cumulator writeCumulator, EmbeddedChannel channel) {
        super(alloc, handler, channel);
        this.cumulator = (ByteToMessageDecoder.Cumulator)ObjectUtil.checkNotNull((Object)writeCumulator, (String)"writeCumulator");
    }

    public final ByteBuf cumulation() {
        return this.cumulation;
    }

    public final void releaseCumulation() {
        if (this.cumulation != null) {
            this.cumulation.release();
            this.cumulation = null;
        }
    }

    @Override
    public final ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    @Override
    public final ChannelFuture write(Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof ByteBuf) {
                this.cumulation = this.cumulation == null ? (ByteBuf)msg : this.cumulator.cumulate(this.alloc(), this.cumulation, (ByteBuf)msg);
                promise.setSuccess();
            } else {
                this.channel().write(msg, promise);
            }
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    @Override
    public final ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                this.cumulation = this.cumulation == null ? buf : this.cumulator.cumulate(this.alloc(), this.cumulation, buf);
                promise.setSuccess();
            } else {
                this.channel().writeAndFlush(msg, promise);
            }
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    @Override
    public final ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }
}

