/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.handler.ssl;

import io.netty.microbench.handler.ssl.AbstractSslEngineThroughputBenchmark;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;

@State(value=Scope.Benchmark)
@Threads(value=1)
public class SslEngineEchoBenchmark
extends AbstractSslEngineThroughputBenchmark {
    @Param(value={"1", "2", "5", "10"})
    public int numWraps;
    private ByteBuffer unwrapDstBuffer;

    @Override
    protected void doSetup() {
        this.unwrapDstBuffer = this.allocateBuffer(this.serverEngine.getSession().getApplicationBufferSize() << 2);
    }

    @Override
    protected void doTearDown() {
        this.freeBuffer(this.unwrapDstBuffer);
    }

    @Benchmark
    public ByteBuffer wrapUnwrap() throws SSLException {
        SSLEngineResult unwrapResult;
        ByteBuffer src = this.doWrap(this.numWraps);
        src.flip();
        this.unwrapDstBuffer.clear();
        while ((unwrapResult = this.serverEngine.unwrap(src, this.unwrapDstBuffer)).getStatus() == SSLEngineResult.Status.OK && src.hasRemaining()) {
        }
        assert (SslEngineEchoBenchmark.checkSslEngineResult(unwrapResult, src, this.unwrapDstBuffer));
        return this.unwrapDstBuffer;
    }
}

