/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbenchmark.common;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.NetUtil;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=4)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class NetUtilBenchmark
extends AbstractMicrobenchmark {
    private static final Map<String, byte[]> invalidIpV4Hosts = new HashMap<String, byte[]>(){
        private static final long serialVersionUID = 1299215199895717282L;
        {
            this.put("1.256.3.4", null);
            this.put("256.0.0.1", null);
            this.put("1.1.1.1.1", null);
            this.put("x.255.255.255", null);
            this.put("0.1:0.0", null);
            this.put("0.1.0.0:", null);
            this.put("127.0.0.", null);
            this.put("1.2..4", null);
            this.put("192.0.1", null);
            this.put("192.0.1.1.1", null);
            this.put("192.0.1.a", null);
            this.put("19a.0.1.1", null);
            this.put("a.0.1.1", null);
            this.put(".0.1.1", null);
            this.put("...", null);
        }
    };
    private static final Map<String, byte[]> invalidIpV6Hosts = new HashMap<String, byte[]>(){
        private static final long serialVersionUID = -5870810805409009696L;
        {
            this.put("Obvious Garbage", null);
            this.put("0:1:2:3:4:5:6:7:8", null);
            this.put("0:1:2:3:4:5:6", null);
            this.put("0:1:2:3:4:5:6:x", null);
            this.put("0:1:2:3:4:5:6::7", null);
            this.put("0:1:2:3:4:5:6:7::", null);
            this.put("::0:1:2:3:4:5:6:7", null);
            this.put("1:2:3:4:5:6:7:", null);
            this.put(":1:2:3:4:5:6:7", null);
            this.put("0::1:2:3:4:5:6:7", null);
            this.put("0:1:2:3:4:5:6:789abcdef", null);
            this.put("0:1:2:3::x", null);
            this.put("0:1:2:::3", null);
            this.put("0:1:2:3::abcde", null);
            this.put("0:1:2:3:4:5:6:7:8", null);
            this.put("0:1", null);
            this.put("0:0:0:0:0:x:10.0.0.1", null);
            this.put("0:0:0:0:0:0:10.0.0.x", null);
            this.put("0:0:0:0:0::0:10.0.0.1", null);
            this.put("0:0:0:0:0:00000:10.0.0.1", null);
            this.put("0:0:0:0:0:0:0:10.0.0.1", null);
            this.put("0:0:0:0:0:10.0.0.1", null);
            this.put("0:0:0:0:0:0:10.0.0.0.1", null);
            this.put("0:0:0:0:0:0:10.0.1", null);
            this.put("0:0:0:0:0:0:10..0.0.1", null);
            this.put("0:0:0:0:0:0:.0.0.1", null);
            this.put("0:0:0:0:0:0:.10.0.0.1", null);
            this.put("0:0:0:0:0:0:10.0.0.", null);
            this.put("0:0:0:0:0:0:10.0.0.1.", null);
            this.put("::fffx:192.168.0.1", null);
            this.put("::ffff:192.168.0.x", null);
            this.put(":::ffff:192.168.0.1", null);
            this.put("::fffff:192.168.0.1", null);
            this.put("::ffff:1923.168.0.1", null);
            this.put(":ffff:192.168.0.1", null);
            this.put("::ffff:192.168.0.1.2", null);
            this.put("::ffff:192.168.0", null);
            this.put("::ffff:192.168..0.1", null);
            this.put("absolute, and utter garbage", null);
            this.put("x:0:0:0:0:0:10.0.0.1", null);
            this.put("0:0:0:0:0:0:x.0.0.1", null);
            this.put("00000:0:0:0:0:0:10.0.0.1", null);
            this.put("0:0:0:0:0:0:10.0.0.1000", null);
            this.put("0:0:0:0:0:0:0:10.0.0.1", null);
            this.put("0:0:0:0:0:10.0.0.1", null);
            this.put("0:0:0:0:0:10.0.0.1:", null);
            this.put(":0:0:0:0:0:10.0.0.1", null);
            this.put("0:0:0:0::10.0.0.1:", null);
            this.put(":0:0:0:0::10.0.0.1", null);
            this.put("0:0:0:0:0:0:10.0.0.0.1", null);
            this.put("0:0:0:0:0:0:10.0.1", null);
            this.put("0:0:0:0:0:0:10.0.0..1", null);
            this.put("::0::", null);
            this.put("", null);
            this.put("2001:0:4136:e378:8000:63bf:3fff:fdd2:", null);
            this.put(":aaaa:bbbb:cccc:dddd:eeee:ffff:1111:2222", null);
            this.put("1234:2345:3456:4567:5678:6789::X890", null);
            this.put("::ffff:255.255.255.255.", null);
            this.put("::ffff:0.0.1111.0", null);
            this.put("::ffff:0.0..0", null);
            this.put("::ffff:127.0.0.", null);
            this.put("::ffff:1.2.4", null);
            this.put("::ffff:192.168.0.1.255", null);
            this.put(":ffff:192.168.0.1.255", null);
            this.put("::ffff:255.255:255.255.", null);
        }
    };

    @Benchmark
    public void useGetByNameIpv4() {
        for (String testEntry : invalidIpV4Hosts.keySet()) {
            if (NetUtil.getByName((CharSequence)testEntry, (boolean)true) == null) continue;
            throw new RuntimeException("error");
        }
    }

    @Benchmark
    public void useGetByNameIpv6() {
        for (String testEntry : invalidIpV6Hosts.keySet()) {
            if (NetUtil.getByName((CharSequence)testEntry, (boolean)true) == null) continue;
            throw new RuntimeException("error");
        }
    }

    @Benchmark
    public void useIsValidIpv6() {
        for (String host : invalidIpV6Hosts.keySet()) {
            if (!NetUtil.isValidIpV6Address((String)host)) continue;
            throw new RuntimeException("error");
        }
    }

    @Benchmark
    public void useIsValidIpv4() {
        for (String host : invalidIpV4Hosts.keySet()) {
            if (!NetUtil.isValidIpV4Address((String)host)) continue;
            throw new RuntimeException("error");
        }
    }
}

