/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.internal;

import io.netty.microbench.util.AbstractMicrobenchmark;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.URIParameter;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class PrivilegedSocketOperationsBenchmark
extends AbstractMicrobenchmark {
    @Benchmark
    public ServerSocketChannel testWithSMNoPrivileged(SecurityManagerInstalled sm) throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.socket().bind(null);
        ssc.configureBlocking(false);
        ssc.accept();
        ssc.close();
        return ssc;
    }

    @Benchmark
    public ServerSocketChannel testWithSM(SecurityManagerInstalled sm) throws IOException {
        try {
            ServerSocketChannel ssc = AccessController.doPrivileged(new PrivilegedExceptionAction<ServerSocketChannel>(){

                @Override
                public ServerSocketChannel run() throws Exception {
                    ServerSocketChannel ssc = ServerSocketChannel.open();
                    ssc.socket().bind(null);
                    ssc.configureBlocking(false);
                    ssc.accept();
                    return ssc;
                }
            });
            ssc.close();
            return ssc;
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    @Benchmark
    public ServerSocketChannel testWithSMWithNullCheck(SecurityManagerInstalled sm) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                ServerSocketChannel ssc = AccessController.doPrivileged(new PrivilegedExceptionAction<ServerSocketChannel>(){

                    @Override
                    public ServerSocketChannel run() throws Exception {
                        ServerSocketChannel ssc = ServerSocketChannel.open();
                        ssc.socket().bind(null);
                        ssc.configureBlocking(false);
                        ssc.accept();
                        return ssc;
                    }
                });
                ssc.close();
                return ssc;
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
        }
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.socket().bind(null);
        ssc.configureBlocking(false);
        ssc.accept();
        ssc.close();
        return ssc;
    }

    @Benchmark
    public ServerSocketChannel testWithoutSMNoPrivileged(SecurityManagerEmpty sm) throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.socket().bind(null);
        ssc.configureBlocking(false);
        ssc.accept();
        ssc.close();
        return ssc;
    }

    @Benchmark
    public ServerSocketChannel testWithoutSM(SecurityManagerEmpty sm) throws IOException {
        try {
            ServerSocketChannel ssc = AccessController.doPrivileged(new PrivilegedExceptionAction<ServerSocketChannel>(){

                @Override
                public ServerSocketChannel run() throws Exception {
                    ServerSocketChannel ssc = ServerSocketChannel.open();
                    ssc.socket().bind(null);
                    ssc.configureBlocking(false);
                    ssc.accept();
                    return ssc;
                }
            });
            ssc.close();
            return ssc;
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    @Benchmark
    public ServerSocketChannel testWithoutSMWithNullCheck(SecurityManagerEmpty sm) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                ServerSocketChannel ssc = AccessController.doPrivileged(new PrivilegedExceptionAction<ServerSocketChannel>(){

                    @Override
                    public ServerSocketChannel run() throws Exception {
                        ServerSocketChannel ssc = ServerSocketChannel.open();
                        ssc.socket().bind(null);
                        ssc.configureBlocking(false);
                        ssc.accept();
                        return ssc;
                    }
                });
                ssc.close();
                return ssc;
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
        }
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.socket().bind(null);
        ssc.configureBlocking(false);
        ssc.accept();
        ssc.close();
        return ssc;
    }

    @State(value=Scope.Benchmark)
    public static class SecurityManagerEmpty {
        @Setup
        public void setup() throws IOException, NoSuchAlgorithmException, URISyntaxException {
            System.setSecurityManager(null);
        }
    }

    @State(value=Scope.Benchmark)
    public static class SecurityManagerInstalled {
        @Setup
        public void setup() throws IOException, NoSuchAlgorithmException, URISyntaxException {
            URI policyFile = PrivilegedSocketOperationsBenchmark.class.getResource("/jmh-security.policy").toURI();
            Policy.setPolicy(Policy.getInstance("JavaPolicy", new URIParameter(policyFile)));
            System.setSecurityManager(new SecurityManager());
        }

        @TearDown
        public void tearDown() throws IOException {
            System.setSecurityManager(null);
        }
    }
}

