/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.headers;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@State(value=Scope.Benchmark)
@Fork(value=2)
@Warmup(iterations=10)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ReadOnlyHttp2HeadersBenchmark
extends AbstractMicrobenchmark {
    private AsciiString[] headerNames;
    private AsciiString[] headerValues;
    @Param(value={"1", "5", "10", "20"})
    public int headerCount;
    private final AsciiString path = new AsciiString((CharSequence)"/BigDynamicPayload");
    private final AsciiString authority = new AsciiString((CharSequence)"io.netty");

    @Setup
    public void setUp() throws Exception {
        this.headerNames = new AsciiString[this.headerCount];
        this.headerValues = new AsciiString[this.headerCount];
        for (int i = 0; i < this.headerCount; ++i) {
            this.headerNames[i] = new AsciiString((CharSequence)("key-" + i));
            this.headerValues[i] = new AsciiString((CharSequence)UUID.randomUUID().toString());
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int defaultTrailers() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < this.headerCount; ++i) {
            headers.add((Object)this.headerNames[i], (Object)this.headerValues[i]);
        }
        return ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)headers);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int readOnlyTrailers() {
        return ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])this.buildPairs()));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int defaultClientHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < this.headerCount; ++i) {
            headers.add((Object)this.headerNames[i], (Object)this.headerValues[i]);
        }
        headers.method((CharSequence)HttpMethod.POST.asciiName());
        headers.scheme((CharSequence)HttpScheme.HTTPS.name());
        headers.path((CharSequence)this.path);
        headers.authority((CharSequence)this.authority);
        return ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)headers);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int readOnlyClientHeaders() {
        return ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)ReadOnlyHttp2Headers.clientHeaders((boolean)false, (AsciiString)HttpMethod.POST.asciiName(), (AsciiString)this.path, (AsciiString)HttpScheme.HTTPS.name(), (AsciiString)this.authority, (AsciiString[])this.buildPairs()));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int defaultServerHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < this.headerCount; ++i) {
            headers.add((Object)this.headerNames[i], (Object)this.headerValues[i]);
        }
        headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        return ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)headers);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int readOnlyServerHeaders() {
        return ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)ReadOnlyHttp2Headers.serverHeaders((boolean)false, (AsciiString)HttpResponseStatus.OK.codeAsText(), (AsciiString[])this.buildPairs()));
    }

    private static int iterate(Http2Headers headers) {
        int length = 0;
        for (Map.Entry entry : headers) {
            length += ((CharSequence)entry.getKey()).length() + ((CharSequence)entry.getValue()).length();
        }
        return length;
    }

    private AsciiString[] buildPairs() {
        AsciiString[] headerPairs = new AsciiString[this.headerCount * 2];
        int i = 0;
        int j = 0;
        while (i < this.headerCount) {
            headerPairs[j] = this.headerNames[i];
            headerPairs[++j] = this.headerValues[i];
            ++i;
            ++j;
        }
        return headerPairs;
    }
}

