/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

public abstract class EmbeddedChannelHandlerContext
implements ChannelHandlerContext {
    private static final String HANDLER_NAME = "microbench-delegator-ctx";
    private final EventLoop eventLoop;
    private final Channel channel;
    private final ByteBufAllocator alloc;
    private final ChannelHandler handler;
    private SocketAddress localAddress;

    protected EmbeddedChannelHandlerContext(ByteBufAllocator alloc, ChannelHandler handler, EmbeddedChannel channel) {
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)alloc, (String)"alloc");
        this.channel = (Channel)ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        this.handler = (ChannelHandler)ObjectUtil.checkNotNull((Object)handler, (String)"handler");
        this.eventLoop = (EventLoop)ObjectUtil.checkNotNull((Object)channel.eventLoop(), (String)"eventLoop");
    }

    protected abstract void handleException(Throwable var1);

    public final <T> Attribute<T> attr(AttributeKey<T> key) {
        return null;
    }

    public final <T> boolean hasAttr(AttributeKey<T> key) {
        return false;
    }

    public final Channel channel() {
        return this.channel;
    }

    public final EventExecutor executor() {
        return this.eventLoop;
    }

    public final String name() {
        return HANDLER_NAME;
    }

    public final ChannelHandler handler() {
        return this.handler;
    }

    public final boolean isRemoved() {
        return false;
    }

    public final ChannelHandlerContext fireChannelRegistered() {
        return this;
    }

    public final ChannelHandlerContext fireChannelUnregistered() {
        return this;
    }

    public final ChannelHandlerContext fireChannelActive() {
        return this;
    }

    public final ChannelHandlerContext fireChannelInactive() {
        return this;
    }

    public final ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        try {
            this.handler().exceptionCaught((ChannelHandlerContext)this, cause);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    public final ChannelHandlerContext fireUserEventTriggered(Object event) {
        ReferenceCountUtil.release((Object)event);
        return this;
    }

    public final ChannelHandlerContext fireChannelRead(Object msg) {
        ReferenceCountUtil.release((Object)msg);
        return this;
    }

    public final ChannelHandlerContext fireChannelReadComplete() {
        return this;
    }

    public final ChannelHandlerContext fireChannelWritabilityChanged() {
        return this;
    }

    public final ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    public final ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    public final ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    public final ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    public final ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    public final ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        try {
            this.channel().bind(localAddress, promise);
            this.localAddress = localAddress;
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public final ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        try {
            this.channel().connect(remoteAddress, this.localAddress, promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public final ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        try {
            this.channel().connect(remoteAddress, localAddress, promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public final ChannelFuture disconnect(ChannelPromise promise) {
        try {
            this.channel().disconnect(promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public final ChannelFuture close(ChannelPromise promise) {
        try {
            this.channel().close(promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public final ChannelFuture deregister(ChannelPromise promise) {
        try {
            this.channel().deregister(promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public final ChannelHandlerContext read() {
        try {
            this.channel().read();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    public ChannelFuture write(Object msg) {
        return this.channel().write(msg);
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.channel().write(msg, promise);
    }

    public final ChannelHandlerContext flush() {
        this.channel().flush();
        return this;
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.channel().writeAndFlush(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    public final ChannelPipeline pipeline() {
        return this.channel().pipeline();
    }

    public final ByteBufAllocator alloc() {
        return this.alloc;
    }

    public final ChannelPromise newPromise() {
        return this.channel().newPromise();
    }

    public final ChannelProgressivePromise newProgressivePromise() {
        return this.channel().newProgressivePromise();
    }

    public final ChannelFuture newSucceededFuture() {
        return this.channel().newSucceededFuture();
    }

    public final ChannelFuture newFailedFuture(Throwable cause) {
        return this.channel().newFailedFuture(cause);
    }

    public final ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }
}

