/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.internal;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=3, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=3, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=2)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
public class UnitializedArrayBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"1", "10", "100", "1000", "10000", "100000"})
    private int size;

    @Setup(value=Level.Trial)
    public void setupTrial() {
        if (PlatformDependent.javaVersion() < 9) {
            throw new IllegalStateException("Needs Java9");
        }
        if (!PlatformDependent.hasUnsafe()) {
            throw new IllegalStateException("Needs Unsafe");
        }
    }

    @Override
    protected String[] jvmArgs() {
        return new String[]{"-XX:+UseParallelOldGC", "-Xmx8g", "-Xms8g", "-Xmn6g", "--add-opens", "java.base/jdk.internal.misc=ALL-UNNAMED"};
    }

    @Benchmark
    public byte[] allocateInitializedByteArray() {
        return new byte[this.size];
    }

    @Benchmark
    public byte[] allocateUninitializedByteArray() {
        return PlatformDependent.allocateUninitializedArray((int)this.size);
    }
}

