/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbenchmark.common;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.NetUtil;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class IsValidIpV6Benchmark
extends AbstractMicrobenchmark {
    @Param(value={"127.0.0.1", "fdf8:f53b:82e4::53", "2001::1", "2001:0000:4136:e378:8000:63bf:3fff:fdd2", "0:0:0:0:0:0:10.0.0.1"})
    private String ip;

    private static boolean isValidIp4Word(String word) {
        if (word.length() < 1 || word.length() > 3) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return Integer.parseInt(word) <= 255;
    }

    private static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidIPv4MappedChar(char c) {
        return c == 'f' || c == 'F';
    }

    public static boolean isValidIpV6AddressOld(String ipAddress) {
        int percentIdx;
        boolean doubleColon = false;
        int numberOfColons = 0;
        int numberOfPeriods = 0;
        StringBuilder word = new StringBuilder();
        char c = '\u0000';
        int startOffset = 0;
        int endOffset = ipAddress.length();
        if (endOffset < 2) {
            return false;
        }
        if (ipAddress.charAt(0) == '[') {
            if (ipAddress.charAt(endOffset - 1) != ']') {
                return false;
            }
            startOffset = 1;
            --endOffset;
        }
        if ((percentIdx = ipAddress.indexOf(37, startOffset)) >= 0) {
            endOffset = percentIdx;
        }
        block4: for (int i = startOffset; i < endOffset; ++i) {
            char prevChar = c;
            c = ipAddress.charAt(i);
            switch (c) {
                case '.': {
                    if (++numberOfPeriods > 3) {
                        return false;
                    }
                    if (numberOfPeriods == 1) {
                        int j = i - word.length() - 2;
                        int beginColonIndex = ipAddress.lastIndexOf(58, j);
                        if (beginColonIndex == -1) {
                            return false;
                        }
                        char tmpChar = ipAddress.charAt(j);
                        if (IsValidIpV6Benchmark.isValidIPv4MappedChar(tmpChar)) {
                            if (!(j - beginColonIndex == 4 && IsValidIpV6Benchmark.isValidIPv4MappedChar(ipAddress.charAt(j - 1)) && IsValidIpV6Benchmark.isValidIPv4MappedChar(ipAddress.charAt(j - 2)) && IsValidIpV6Benchmark.isValidIPv4MappedChar(ipAddress.charAt(j - 3)))) {
                                return false;
                            }
                            j -= 5;
                        } else if (tmpChar == '0' || tmpChar == ':') {
                            --j;
                        } else {
                            return false;
                        }
                        if (numberOfColons != 6 && !doubleColon || numberOfColons > 7 || numberOfColons == 7 && (ipAddress.charAt(startOffset) != ':' || ipAddress.charAt(1 + startOffset) != ':')) {
                            return false;
                        }
                        while (j >= startOffset) {
                            tmpChar = ipAddress.charAt(j);
                            if (tmpChar != '0' && tmpChar != ':') {
                                return false;
                            }
                            --j;
                        }
                    }
                    if (!IsValidIpV6Benchmark.isValidIp4Word(word.toString())) {
                        return false;
                    }
                    word.delete(0, word.length());
                    continue block4;
                }
                case ':': {
                    if (i == startOffset && (endOffset <= i || ipAddress.charAt(i + 1) != ':')) {
                        return false;
                    }
                    if (++numberOfColons > 8) {
                        return false;
                    }
                    if (numberOfPeriods > 0) {
                        return false;
                    }
                    if (prevChar == ':') {
                        if (doubleColon) {
                            return false;
                        }
                        doubleColon = true;
                    }
                    word.delete(0, word.length());
                    continue block4;
                }
                default: {
                    if (word != null && word.length() > 3) {
                        return false;
                    }
                    if (!IsValidIpV6Benchmark.isValidHexChar(c)) {
                        return false;
                    }
                    word.append(c);
                }
            }
        }
        if (numberOfPeriods > 0) {
            if (numberOfPeriods != 3 || !IsValidIpV6Benchmark.isValidIp4Word(word.toString()) || numberOfColons >= 7 && !doubleColon) {
                return false;
            }
        } else {
            if (numberOfColons != 7 && !doubleColon) {
                return false;
            }
            if (word.length() == 0 ? ipAddress.charAt(endOffset - 1) == ':' && ipAddress.charAt(endOffset - 2) != ':' : numberOfColons == 8 && ipAddress.charAt(startOffset) != ':') {
                return false;
            }
        }
        return true;
    }

    @Benchmark
    public boolean isValidIpV6AddressOld() {
        return IsValidIpV6Benchmark.isValidIpV6AddressOld(this.ip);
    }

    @Benchmark
    public boolean isValidIpV6AddressNew() {
        return NetUtil.isValidIpV6Address((String)this.ip);
    }
}

