/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class QueryStringEncoderBenchmark
extends AbstractMicrobenchmark {
    private String shortAscii;
    private String shortUtf8;
    private String shortAsciiFirst;
    private String longAscii;
    private String longUtf8;
    private String longAsciiFirst;

    @Setup
    public void setUp() {
        this.shortAscii = new String("foo".toCharArray());
        this.shortUtf8 = new String("\u307b\u3052\u307b\u3052".toCharArray());
        this.shortAsciiFirst = this.shortAscii + this.shortUtf8;
        this.longAscii = QueryStringEncoderBenchmark.repeat(this.shortAscii, 100);
        this.longUtf8 = QueryStringEncoderBenchmark.repeat(this.shortUtf8, 100);
        this.longAsciiFirst = this.longAscii + this.longUtf8;
    }

    @Benchmark
    public String shortAscii() {
        return QueryStringEncoderBenchmark.encode(this.shortAscii);
    }

    @Benchmark
    public String shortUtf8() {
        return QueryStringEncoderBenchmark.encode(this.shortUtf8);
    }

    @Benchmark
    public String shortAsciiFirst() {
        return QueryStringEncoderBenchmark.encode(this.shortAsciiFirst);
    }

    @Benchmark
    public String longAscii() {
        return QueryStringEncoderBenchmark.encode(this.longAscii);
    }

    @Benchmark
    public String longUtf8() {
        return QueryStringEncoderBenchmark.encode(this.longUtf8);
    }

    @Benchmark
    public String longAsciiFirst() {
        return QueryStringEncoderBenchmark.encode(this.longAsciiFirst);
    }

    private static String encode(String s) {
        QueryStringEncoder encoder = new QueryStringEncoder("");
        encoder.addParam(s, s);
        return encoder.toString();
    }

    private static String repeat(String s, int num) {
        StringBuilder sb = new StringBuilder(num * s.length());
        for (int i = 0; i < num; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }
}

