/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.microbench.channel.EmbeddedChannelWriteAccumulatingHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.openjdk.jmh.annotations.Param;

public class AbstractSslHandlerBenchmark
extends AbstractMicrobenchmark {
    private static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    @Param
    public SslEngineProvider sslProvider;
    @Param(value={"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"})
    public String cipher;
    protected SslHandler clientSslHandler;
    protected SslHandler serverSslHandler;
    protected EmbeddedChannelWriteAccumulatingHandlerContext clientCtx;
    protected EmbeddedChannelWriteAccumulatingHandlerContext serverCtx;

    protected final void initSslHandlers(ByteBufAllocator allocator) {
        this.clientSslHandler = this.newClientHandler(allocator);
        this.serverSslHandler = this.newServerHandler(allocator);
        this.clientCtx = new SslThroughputBenchmarkHandlerContext(allocator, (ChannelHandler)this.clientSslHandler, ByteToMessageDecoder.COMPOSITE_CUMULATOR);
        this.serverCtx = new SslThroughputBenchmarkHandlerContext(allocator, (ChannelHandler)this.serverSslHandler, ByteToMessageDecoder.COMPOSITE_CUMULATOR);
    }

    protected final void destroySslHandlers() {
        try {
            if (this.clientSslHandler != null) {
                ReferenceCountUtil.release((Object)this.clientSslHandler.engine());
            }
        }
        finally {
            if (this.serverSslHandler != null) {
                ReferenceCountUtil.release((Object)this.serverSslHandler.engine());
            }
        }
    }

    protected final void doHandshake() throws Exception {
        this.serverSslHandler.handlerAdded((ChannelHandlerContext)this.serverCtx);
        this.clientSslHandler.handlerAdded((ChannelHandlerContext)this.clientCtx);
        do {
            ByteBuf serverCumulation;
            ByteBuf clientCumulation;
            if ((clientCumulation = this.clientCtx.cumulation()) != null) {
                this.serverSslHandler.channelRead((ChannelHandlerContext)this.serverCtx, (Object)clientCumulation.retain());
                this.clientCtx.releaseCumulation();
            }
            if ((serverCumulation = this.serverCtx.cumulation()) == null) continue;
            this.clientSslHandler.channelRead((ChannelHandlerContext)this.clientCtx, (Object)serverCumulation.retain());
            this.serverCtx.releaseCumulation();
        } while (!this.clientSslHandler.handshakeFuture().isDone() || !this.serverSslHandler.handshakeFuture().isDone());
    }

    protected final SslHandler newClientHandler(ByteBufAllocator allocator) {
        return this.sslProvider.newClientHandler(allocator, this.cipher);
    }

    protected final SslHandler newServerHandler(ByteBufAllocator allocator) {
        return this.sslProvider.newServerHandler(allocator, this.cipher);
    }

    public static void handleUnexpectedException(Throwable t) {
        if (t != null) {
            throw new IllegalStateException(t);
        }
    }

    private static final class SslThroughputBenchmarkHandlerContext
    extends EmbeddedChannelWriteAccumulatingHandlerContext {
        SslThroughputBenchmarkHandlerContext(ByteBufAllocator alloc, ChannelHandler handler, ByteToMessageDecoder.Cumulator writeCumulator) {
            super(alloc, handler, writeCumulator);
        }

        @Override
        protected void handleException(Throwable t) {
            AbstractSslHandlerBenchmark.handleUnexpectedException(t);
        }
    }

    public static enum SslEngineProvider {
        JDK{

            @Override
            SslProvider sslProvider() {
                return SslProvider.JDK;
            }
        }
        ,
        OPENSSL{

            @Override
            SslProvider sslProvider() {
                return SslProvider.OPENSSL;
            }
        }
        ,
        OPENSSL_REFCNT{

            @Override
            SslProvider sslProvider() {
                return SslProvider.OPENSSL_REFCNT;
            }
        };

        private final SslContext clientContext = this.newClientContext();
        private final SslContext serverContext = this.newServerContext();

        private SslContext newClientContext() {
            try {
                return SslContextBuilder.forClient().sslProvider(this.sslProvider()).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new IllegalStateException(e);
            }
        }

        private SslContext newServerContext() {
            try {
                File keyFile = new File(((Object)((Object)this)).getClass().getResource("test_unencrypted.pem").getFile());
                File crtFile = new File(((Object)((Object)this)).getClass().getResource("test.crt").getFile());
                return SslContextBuilder.forServer((File)crtFile, (File)keyFile).sslProvider(this.sslProvider()).build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        SslHandler newClientHandler(ByteBufAllocator allocator, String cipher) {
            SslHandler handler = this.clientContext.newHandler(allocator);
            SslEngineProvider.configureEngine(handler.engine(), cipher);
            return handler;
        }

        SslHandler newServerHandler(ByteBufAllocator allocator, String cipher) {
            SslHandler handler = this.serverContext.newHandler(allocator);
            SslEngineProvider.configureEngine(handler.engine(), cipher);
            return handler;
        }

        abstract SslProvider sslProvider();

        static SSLEngine configureEngine(SSLEngine engine, String cipher) {
            engine.setEnabledProtocols(new String[]{AbstractSslHandlerBenchmark.PROTOCOL_TLS_V1_2});
            engine.setEnabledCipherSuites(new String[]{cipher});
            return engine;
        }
    }
}

