/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.Recycler;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class RecyclerBenchmark
extends AbstractMicrobenchmark {
    private Recycler<DummyObject> recycler = new Recycler<DummyObject>(){

        protected DummyObject newObject(Recycler.Handle<DummyObject> handle) {
            return new DummyObject(handle);
        }
    };

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        return super.newOptionsBuilder().addProfiler("gc");
    }

    @Benchmark
    public DummyObject plainNew() {
        return new DummyObject();
    }

    @Benchmark
    public DummyObject recyclerGetAndOrphan() {
        return (DummyObject)this.recycler.get();
    }

    @Benchmark
    public DummyObject recyclerGetAndRecycle() {
        DummyObject o = (DummyObject)this.recycler.get();
        o.recycle();
        return o;
    }

    @Benchmark
    @Group(value="producerConsumer")
    public void producer(ProducerConsumerState state, Control control) throws Exception {
        ArrayBlockingQueue<DummyObject> queue = state.queue;
        DummyObject object = (DummyObject)this.recycler.get();
        while (!control.stopMeasurement && !queue.offer(object)) {
        }
    }

    @Benchmark
    @Group(value="producerConsumer")
    public void consumer(ProducerConsumerState state, Control control) throws Exception {
        do {
            DummyObject object;
            if ((object = state.queue.poll()) == null) continue;
            object.recycle();
            return;
        } while (!control.stopMeasurement);
    }

    private static final class DummyObject {
        private final Recycler.Handle<DummyObject> handle;
        private long l1;
        private long l2;
        private long l3;
        private long l4;
        private long l5;
        private Object o1;
        private Object o2;
        private Object o3;
        private Object o4;
        private Object o5;

        DummyObject() {
            this(null);
        }

        DummyObject(Recycler.Handle<DummyObject> handle) {
            this.handle = handle;
        }

        public void recycle() {
            this.handle.recycle((Object)this);
        }
    }

    @State(value=Scope.Benchmark)
    public static class ProducerConsumerState {
        final ArrayBlockingQueue<DummyObject> queue = new ArrayBlockingQueue(100);
    }
}

