/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufNoCleanerBenchmark;
import io.netty.buffer.ByteBuf;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@Threads(value=16)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class ByteBufNoCleanerChangeCapacityBenchmark
extends AbstractByteBufNoCleanerBenchmark {
    private static final int MAX_DIRECT_MEMORY_PER_THREAD = 0x100000;
    @Param(value={"1024"})
    public int initialCapacity;

    @Benchmark
    public boolean capacityChange() {
        ByteBuf buffer = this.bufferType.newBuffer(this.initialCapacity);
        for (int newCapacity = this.initialCapacity << 1; newCapacity <= 0x100000; newCapacity += this.initialCapacity) {
            buffer.capacity(newCapacity);
        }
        return buffer.release();
    }
}

