/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakHint;
import io.netty.util.ResourceLeakTracker;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class ResourceLeakDetectorRecordBenchmark
extends AbstractMicrobenchmark {
    private static final Object TRACKED = new Object();
    private static final ResourceLeakHint HINT = new ResourceLeakHint(){

        public String toHintString() {
            return "BenchmarkHint";
        }
    };
    @Param(value={"8", "16"})
    private int recordTimes;
    private ResourceLeakDetector.Level level;
    ResourceLeakDetector<Object> detector = new ResourceLeakDetector<Object>(Object.class, 1, Integer.MAX_VALUE){

        protected void reportTracedLeak(String resourceType, String records) {
        }

        protected void reportUntracedLeak(String resourceType) {
        }

        protected void reportInstancesLeak(String resourceType) {
        }
    };

    @Setup(value=Level.Trial)
    public void setup() {
        this.level = ResourceLeakDetector.getLevel();
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)this.level);
    }

    @Benchmark
    public boolean record() {
        ResourceLeakTracker tracker = this.detector.track(TRACKED);
        for (int i = 0; i < this.recordTimes; ++i) {
            tracker.record();
        }
        return tracker.close(TRACKED);
    }

    @Benchmark
    public boolean recordWithHint() {
        ResourceLeakTracker tracker = this.detector.track(TRACKED);
        for (int i = 0; i < this.recordTimes; ++i) {
            tracker.record((Object)HINT);
        }
        return tracker.close(TRACKED);
    }
}

