/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbenchmark.common;

import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.Random;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=5)
public class AppendableCharSequenceBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"32", "64", "128", "256"})
    private int charsInitSize;
    @Param(value={"10", "100", "10000", "1000000"})
    private int simulatedDataSize;
    private static final Random rand = new Random();
    private char[] chars;
    private char simulatedData;
    private int pos;

    @Setup(value=Level.Trial)
    public void setup() {
        this.chars = new char[this.charsInitSize];
        this.simulatedData = (char)rand.nextInt();
    }

    @Benchmark
    public void appendCheckBeforeCopy() {
        this.checkReset();
        if (this.pos == this.chars.length) {
            this.expand();
        }
        this.chars[this.pos++] = this.simulatedData;
    }

    @Benchmark
    public void appendCatchExceptionAfter() {
        this.checkReset();
        try {
            this.chars[this.pos++] = this.simulatedData;
        }
        catch (IndexOutOfBoundsException e) {
            this.expand();
            this.chars[this.pos - 1] = this.simulatedData;
        }
    }

    private void checkReset() {
        if (this.pos == this.simulatedDataSize) {
            this.pos = 0;
            this.chars = new char[this.charsInitSize];
        }
    }

    private void expand() {
        char[] old = this.chars;
        int len = old.length << 1;
        if (len < 0) {
            throw new IllegalStateException();
        }
        this.chars = new char[len];
        System.arraycopy(old, 0, this.chars, 0, old.length);
    }
}

