/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=1)
@Threads(value=1)
@State(value=Scope.Benchmark)
@Warmup(iterations=5)
@Measurement(iterations=5)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class HpackStaticTableBenchmark
extends AbstractMicrobenchmark {
    private static final CharSequence X_CONTENT_ENCODING = new AsciiString("x-content-encoding".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence X_GZIP = new AsciiString("x-gzip".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence STATUS = new AsciiString(":status".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence STATUS_200 = new AsciiString("200".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence STATUS_500 = new AsciiString("500".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence AUTHORITY = new AsciiString(":authority".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence AUTHORITY_NETTY = new AsciiString("netty.io".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence USER_AGENT = new AsciiString("user-agent".getBytes(CharsetUtil.US_ASCII), false);
    private static final CharSequence USER_AGENT_CURL = new AsciiString("curl/7.64.1".getBytes(CharsetUtil.US_ASCII), false);

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int lookupNoNameMatch() {
        return HpackStaticTable.getIndexInsensitive((CharSequence)X_CONTENT_ENCODING, (CharSequence)X_GZIP);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int lookupNameAndValueMatchFirst() {
        return HpackStaticTable.getIndexInsensitive((CharSequence)STATUS, (CharSequence)STATUS_200);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int lookupNameAndValueMatchLast() {
        return HpackStaticTable.getIndexInsensitive((CharSequence)STATUS, (CharSequence)STATUS_500);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int lookupNameOnlyMatchBeginTable() {
        return HpackStaticTable.getIndexInsensitive((CharSequence)AUTHORITY, (CharSequence)AUTHORITY_NETTY);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int lookupNameOnlyMatchEndTable() {
        return HpackStaticTable.getIndexInsensitive((CharSequence)USER_AGENT, (CharSequence)USER_AGENT_CURL);
    }
}

