/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.nio.ByteBuffer;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class UnsafeByteBufBenchmark
extends AbstractMicrobenchmark {
    private ByteBuf unsafeBuffer;
    private ByteBuffer byteBuffer;

    @Setup
    public void setup() {
        this.unsafeBuffer = new UnpooledUnsafeDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 64, 64);
        this.byteBuffer = ByteBuffer.allocateDirect(64);
    }

    @TearDown
    public void tearDown() {
        this.unsafeBuffer.release();
    }

    @Benchmark
    public long setGetLongUnsafeByteBuf() {
        return this.unsafeBuffer.setLong(0, 1L).getLong(0);
    }

    @Benchmark
    public long setGetLongByteBuffer() {
        return this.byteBuffer.putLong(0, 1L).getLong(0);
    }

    @Benchmark
    public ByteBuf setLongUnsafeByteBuf() {
        return this.unsafeBuffer.setLong(0, 1L);
    }

    @Benchmark
    public ByteBuffer setLongByteBuffer() {
        return this.byteBuffer.putLong(0, 1L);
    }
}

