/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=1)
public class HttpRequestResponseBenchmark
extends AbstractMicrobenchmark {
    ByteBuf GET;
    int readerIndex;
    int writeIndex;
    EmbeddedChannel nettyChannel;
    @Param(value={"true", "false"})
    boolean websocket;

    @Setup
    public void setup() {
        HttpRequestDecoder httpRequestDecoder = new HttpRequestDecoder(4096, 8192, 8192, false);
        HttpResponseEncoder httpResponseEncoder = new HttpResponseEncoder();
        ChannelInboundHandlerAdapter inboundHandlerAdapter = new ChannelInboundHandlerAdapter(){
            private final byte[] STATIC_PLAINTEXT = "Hello, World!".getBytes(CharsetUtil.UTF_8);
            private final int STATIC_PLAINTEXT_LEN = this.STATIC_PLAINTEXT.length;
            private final ByteBuf PLAINTEXT_CONTENT_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer().writeBytes(this.STATIC_PLAINTEXT));
            private final CharSequence PLAINTEXT_CLHEADER_VALUE = new AsciiString((CharSequence)String.valueOf(this.STATIC_PLAINTEXT_LEN));
            private final CharSequence TYPE_PLAIN = new AsciiString((CharSequence)"text/plain");
            private final CharSequence SERVER_NAME = new AsciiString((CharSequence)"Netty");
            private final CharSequence CONTENT_TYPE_ENTITY = HttpHeaderNames.CONTENT_TYPE;
            private final CharSequence DATE_ENTITY = HttpHeaderNames.DATE;
            private final CharSequence CONTENT_LENGTH_ENTITY = HttpHeaderNames.CONTENT_LENGTH;
            private final CharSequence SERVER_ENTITY = HttpHeaderNames.SERVER;
            private final DateFormat FORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z");
            private final CharSequence date = new AsciiString((CharSequence)this.FORMAT.format(new Date()));

            public void channelRead(ChannelHandlerContext ctx, Object o) {
                if (o == LastHttpContent.EMPTY_LAST_CONTENT) {
                    return;
                }
                if (o.getClass() == DefaultHttpRequest.class) {
                    this.writeResponse(ctx, this.PLAINTEXT_CONTENT_BUFFER.duplicate(), this.TYPE_PLAIN, this.PLAINTEXT_CLHEADER_VALUE);
                } else if (o instanceof HttpRequest) {
                    try {
                        this.writeResponse(ctx, this.PLAINTEXT_CONTENT_BUFFER.duplicate(), this.TYPE_PLAIN, this.PLAINTEXT_CLHEADER_VALUE);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)o);
                    }
                } else {
                    ReferenceCountUtil.release((Object)o);
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) {
                ctx.flush();
            }

            private void writeResponse(ChannelHandlerContext ctx, ByteBuf buf, CharSequence contentType, CharSequence contentLength) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf, false);
                HttpHeaders headers = response.headers();
                headers.set(this.CONTENT_TYPE_ENTITY, (Object)contentType);
                headers.set(this.SERVER_ENTITY, (Object)this.SERVER_NAME);
                headers.set(this.DATE_ENTITY, (Object)this.date);
                headers.set(this.CONTENT_LENGTH_ENTITY, (Object)contentLength);
                ctx.write((Object)response, ctx.voidPromise());
            }
        };
        this.nettyChannel = this.websocket ? new EmbeddedChannel(new ChannelHandler[]{httpRequestDecoder, httpResponseEncoder, new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{new WebSocketServerExtensionHandshaker(){

            public WebSocketServerExtension handshakeExtension(WebSocketExtensionData extensionData) {
                return null;
            }
        }}), inboundHandlerAdapter}) : new EmbeddedChannel(new ChannelHandler[]{httpRequestDecoder, httpResponseEncoder, inboundHandlerAdapter});
        this.nettyChannel.config().setAllocator((ByteBufAllocator)new Alloc());
        this.GET = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])"GET / HTTP/1.1\r\n\r\n".getBytes()));
        this.readerIndex = this.GET.readerIndex();
        this.writeIndex = this.GET.writerIndex();
    }

    @Benchmark
    public Object netty() {
        this.GET.setIndex(this.readerIndex, this.writeIndex);
        this.nettyChannel.writeInbound(new Object[]{this.GET});
        return this.nettyChannel.outboundMessages().poll();
    }

    static class Alloc
    implements ByteBufAllocator {
        private final ByteBuf buf = Unpooled.buffer();
        private final int capacity = this.buf.capacity();

        Alloc() {
        }

        public ByteBuf buffer() {
            this.buf.clear();
            return this.buf;
        }

        public ByteBuf buffer(int initialCapacity) {
            if (initialCapacity <= this.capacity) {
                return this.buffer();
            }
            throw new IllegalArgumentException();
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            if (initialCapacity <= this.capacity) {
                return this.buffer();
            }
            throw new IllegalArgumentException();
        }

        public ByteBuf ioBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer(int initialCapacity) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeHeapBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeDirectBuffer() {
            throw new UnsupportedOperationException();
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectBufferPooled() {
            throw new UnsupportedOperationException();
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            throw new UnsupportedOperationException();
        }
    }
}

