/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.Recycler;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.atomic.MpmcAtomicArrayQueue;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Control;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class RecyclerBenchmark
extends AbstractMicrobenchmark {
    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        return super.newOptionsBuilder().addProfiler("gc");
    }

    @Benchmark
    public DummyObject plainNew() {
        return new DummyObject();
    }

    @Benchmark
    public DummyObject recyclerGetAndOrphan(ProducerConsumerState state) {
        return (DummyObject)state.recycler.get();
    }

    @Benchmark
    public DummyObject recyclerGetAndRecycle(ProducerConsumerState state) {
        DummyObject o = (DummyObject)state.recycler.get();
        o.recycle();
        return o;
    }

    @Benchmark
    public DummyObject recyclerGetAndUnguardedRecycle(ProducerConsumerState state) {
        DummyObject o = (DummyObject)state.recycler.get();
        o.unguardedRecycle();
        return o;
    }

    @Benchmark
    @Group(value="producerConsumer")
    public void producer(ProducerConsumerState state, Control control) throws Exception {
        Queue<DummyObject> queue = state.queue;
        DummyObject object = (DummyObject)state.recycler.get();
        while (!control.stopMeasurement && !queue.offer(object)) {
        }
    }

    @Benchmark
    @Group(value="producerConsumer")
    public void consumer(ProducerConsumerState state, Control control) throws Exception {
        Queue<DummyObject> queue = state.queue;
        do {
            DummyObject object;
            if ((object = queue.poll()) == null) continue;
            object.recycle();
            return;
        } while (!control.stopMeasurement);
    }

    @Benchmark
    @Group(value="unguardedProducerConsumer")
    public void unguardedProducer(ProducerConsumerState state, Control control) throws Exception {
        Queue<DummyObject> queue = state.queue;
        DummyObject object = (DummyObject)state.recycler.get();
        while (!control.stopMeasurement && !queue.offer(object)) {
        }
    }

    @Benchmark
    @Group(value="unguardedProducerConsumer")
    public void unguardedConsumer(ProducerConsumerState state, Control control) throws Exception {
        Queue<DummyObject> queue = state.queue;
        do {
            DummyObject object;
            if ((object = queue.poll()) == null) continue;
            object.unguardedRecycle();
            return;
        } while (!control.stopMeasurement);
    }

    private static final class DummyObject {
        private final Recycler.EnhancedHandle<DummyObject> handle;
        private long l1;
        private long l2;
        private long l3;
        private long l4;
        private long l5;
        private Object o1;
        private Object o2;
        private Object o3;
        private Object o4;
        private Object o5;

        DummyObject() {
            this(null);
        }

        DummyObject(Recycler.EnhancedHandle<DummyObject> handle) {
            this.handle = handle;
        }

        public void recycle() {
            this.handle.recycle((Object)this);
        }

        public void unguardedRecycle() {
            this.handle.unguardedRecycle((Object)this);
        }
    }

    @State(value=Scope.Benchmark)
    public static class ProducerConsumerState {
        Queue<DummyObject> queue;
        Recycler<DummyObject> recycler;

        @Setup
        public void init() {
            this.queue = PlatformDependent.hasUnsafe() ? new MpmcArrayQueue(100) : new MpmcAtomicArrayQueue(100);
            this.recycler = new Recycler<DummyObject>(){

                protected DummyObject newObject(Recycler.Handle<DummyObject> handle) {
                    return new DummyObject((Recycler.EnhancedHandle<DummyObject>)((Recycler.EnhancedHandle)handle));
                }
            };
        }
    }
}

