/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.testsuite.http2.HelloWorldHttp2Handler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;

public class HelloWorldHttp1Handler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String establishApproach;

    HelloWorldHttp1Handler(String establishApproach) {
        this.establishApproach = (String)ObjectUtil.checkNotNull((Object)establishApproach, (String)"establishApproach");
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, ctx.alloc().buffer(0)));
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        ByteBuf content = ctx.alloc().buffer();
        content.writeBytes(HelloWorldHttp2Handler.RESPONSE_BYTES.duplicate());
        ByteBufUtil.writeAscii((ByteBuf)content, (CharSequence)(" - via " + req.protocolVersion() + " (" + this.establishApproach + ")"));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        if (!keepAlive) {
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ctx.write((Object)response);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

